#ifndef __DM_CRESNET_H__
#define __DM_CRESNET_H__

/**
 *
 * \file        dm_cresnet.h
 *
 * \brief       Global cresnet-related definitions used for both master
 *              and slave, "uart" cresnet and CIP.
 *
 * \author      copied from network.h in Cajita code base
 *
 * \date        12/5/2007
 *
 * \note        This is a generic file.  There should be no product-specific
 *              nor processor-specific stuff in here.
 *
 * to do:
 *
 */

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

//New definitions from merged DMCards version

#define DM_NET_BAUD_RATE                    38400
#define DM_INTERNAL_CRESNET_BAUD_RATE       38400

// DmNet Poll Task states
#define POLL_STAT_IDLE          0
#define POLL_STAT_POLL          1
#define POLL_STAT_DISCOVER      2
#define POLL_STAT_TEST          3

//Timeout for Cresnet queue
#define CRESNET_QUEUE_TIMEOUT_10MS      700//200  //2 seconds
#define CRESNET_QUEUE_POLL_RATE         10   //10ms

//Bugzilla fix
//This timeout allows the DM Host output card to work in the mini backplane
#define CRESNET_DM_HOST_TIMEOUT_10MS    1    //1 tick
#define CRESNET_DM_HOST_POLL_RATE       5    //5ms

// debug flags
#define CRESNET_DEBUG_RX                0x01
#define CRESNET_DEBUG_TX                0x02
#define CRESNET_DEBUG_CIP_PKTS          0x04
#define CRESNET_DEBUG_CIP_INIT          0x08
#define CRESNET_DEBUG_HEARTBEAT         0x10
#define CRESNET_DEBUG_RECONNECT         0x20
#define CRESNET_DEBUG_CIP_MSGS          0x04

#define MAX_CRESNET_DEVICES             256

// RAW input buffer leave 0 alone to hold the source - uart or CIP
#define CRESNET_BUF_SRC_OFFSET          0
#define CRESNET_BUF_ID_OFFSET           1
#define CRESNET_BUF_LEN_OFFSET          2
#define CRESNET_BUF_TYPE_OFFSET         3

// offsets within a packet
#define CNET_ID_OFFSET                  0
#define CNET_LEN_OFFSET                 1
#define CNET_TYPE_OFFSET                2

#define UPDATE_REQUEST                  0x00

/* modes for the network timer ISR */
#define CNET_START                           0
#define CNET_SENDTOKEN                       1
#define CNET_WAIT_AFTER_SEND                 2 // only needed for 5272 because of the uart's transmit fifo
#define CNET_RELEASE_BUS                     3
#define CNET_WAIT_BEFORE_BREAK               4
#define CNET_WAIT_DURING_BREAK               5
#define CNET_WAIT_AFTER_BREAK                6

#define BITS_PER_CHAR                   11

#define CAPABILITY_BASIC_TYPE     0x0
#define CAPABILITY_LAST_PACKET    0x0
#define CAPABILITY_MORE_PACKETS   0x01
#define MAX_CAPABILITY_LENGTH  250
#define CAPABILITY_HEADER_SIZE    6
#define SERIAL_HEADER_SIZE        6
#define ENCAP_OFFSET              3

#define CAPABILITY_REQ_TYPE      3
#define CAPABILITY_REQ_FLAGS     4
#define CAPABILITY_REQ_TRANS_NUM 5

#define MAX_CRESNET_MSG_OUT 240
    
// Cresnet Errors
typedef enum
{
    // FATAL
    ERR_CNET_NO_MEMORY,                                 //0 unable to get memory at initialization
    // ERRORS                                           
    ERR_CNET_OUT_QUEUE_FULL,                            //1 output queue full, message dropped
    ERR_CNET_INVALID_STREAM,                            //2 a message was sent to an unsupported stream
    ERR_CNET_MEMORIZE_TABLE,                            //3 ran out of entries in memorize table
    // WARNINGS                                         
    ERR_CNET_XFER_ABORT,                                //4 Cresnet transfer aborted
    ERR_CNET_REC_UNKNOWN_CMD,                           //5 received  unknown cmd
    ERR_CNET_RX_UNKNOWN_PKT,                            //6 unknown rx packet type
    ERR_CNET_BAD_NEST_ENCAPSULATION,                    //7 unsupported nested encapsulation
    ERR_CNET_DROPPING_PKT,                              //8 dropping packet on input
    ERR_CNET_RESET_TX_QUEUE,                            //9 resetting tx queue
    ERR_CNET_RESET_TX_PIPE,                             //10 resetting tx pipe
    ERR_CNET_UNKNOWN_DIGITAL,                           //11 unknown digital join
    ERR_CNET_UNKNOWN_ANALOG,                            //12 unknown analog join
    ERR_CNET_UNKNOWN_SERIAL,                            //13 unknown serial join

    ERR_CNET_REC_ALL_CLEAR,                             //14 received all clear
    ERR_CNET_REC_SEL_ALL_CLEAR,                         //15 received selective all clear
    ERR_CNET_REC_END_UPDATE,                            //16 Received end of update
    ERR_CNET_REC_SEND_UPDATE_REQ,                       //17 sending update request

    ERR_CNET_MSTR_BAD_STATE,                            //18 unexpected cresnet master state
    ERR_CNET_MSTR_NO_RESP,                              //19 no response from device
    ERR_CNET_UNSUPPORTED_SLOT_ID,                       //20 only support 4 subslots
    ERR_CNET_UNSUPPORTED_PORT,                          //21 unknown card port#
    ERR_CNET_DROP_PKT_SENDING,                          //22 dropping packet on output
    ERR_CNET_ENCAP_RX_DROP_PKT,                         //23
    ERR_CNET_NAME_REQ_TIMEOUT,                          //24
    ERR_CNET_DROP_TJI_SENDING,                          //25
    ERR_CNET_DROP_CONSOLE_PKT_SENDING,                  //26
    ERR_CNET_UNABLE_TO_GET_BUFFER,                      //27
    ERR_CNET_MSTR_LINK_MEM_MGR_INIT,                    //28
    ERR_CNET_MSTR_POLL_MGR_INIT,                        //29
	ERR_CNET_DMNET_MAPPER_UNINITIALIZED,                //30
    ERR_CNET_SLAVE_QUEUE_FULL_WAIT_TIMEOUT,             //31
    ERR_CNET_UART_OVERFLOW,                             //32 UART Overflow    
    ERR_CNET_SLAVE_RCON_TIMER_CREATE_FAILED,            //33   
    ERR_CNET_SLAVE_RCON_TIMER_ADD_PACKET_FAILED,        //34   
    MAX_ERR_CNET_SLAVE
}ERR_CNET;

#define NET_SOURCE_INVALID              -1
#define NET_SOURCE_CRESNET              2
#define NET_SOURCE_CRESNET_BROADCAST    3

//extern void UartCresnetTx(UINT32 inst, UINT8 data);
//extern void CresnetSlaveSendPacketViaCIP(void *,UINT8 * packet, UINT32 packet_size);
UINT8* GetCresnetBuffer( UINT16 size );
void ReleaseCresnetBuffer(UINT8 *buffer);
void GetCresnetSlaveLock( void);
void ReleaseCresnetSlaveLock( void);
extern UINT32 CresnetSlaveLockId;

char const *GetCapabilityString(UINT8 iStream);
char const *GetExtendedCapabilityString(UINT8 iStream);
void CresnetDmJoinRefresh(UINT8 bStream);

#ifdef __cplusplus
}
#endif

#endif

